
bl_info = {
    "name" : "Dynamic Grooming",
    "author" : "Carlos Barreto",
    "description" : "",
    "blender" : (3, 0, 0),
    "version" : (0, 0, 67),
    "location" : "View3D",
    "warning" : "",
    "category" : "Generic"
}

## 0.65 - changed the shortcut to CTRL + D to avoid problems with annotation
## 0.66 - fix for problem when deleting hair manually (not a good fix, just a workaround)
## 0.67 - Fix shapekey name disapeard
import bpy
from bpy.types import Menu
from bpy.props import PointerProperty,CollectionProperty
import addon_utils

from . hair import *
from . panel import *
import json

classes = (HD_PT_PanelDynaGroom,DynaGroomSettings,ApplyHair,SelectRoot,SelectRootAndNext,
            ModeTip,SelectPointLess,SelectPointMore,ModePath,ModePoint,SelectTip,InvertSelection,
            ToggleParticleContext,AddDynamics,AddHairParticles,
            CreateHairSections,EditHairSections,ClearVgDensitySelection,ParticleEditClear
            ,HqHair,MqHair,LqHair
            ,Hair1,Hair2
            ,SavePreset,LoadPreset
            ,SaveStyle,LoadStyle
            ,FindContext
            ,HideViewportHair,ShowViewportHair
            ,HideRenderHair,ShowRenderHair
            ,HairDynamicsOn,HairDynamicsOff
            ,ImportPresetOrStyle,ExportPresetOrStyle
            ,Rewind,PlayPause
            ,UpdtPanelFromParticles
            ,AddHairSections
            ,UpdtParticlesDisplay
            ,SetWeight0,SetWeight50,SetWeight100
            ,UpdtPreserveRootLength
            ,UnselectAll
            ,MY_UL_List,ListItem,LIST_OT_NewItem,LIST_OT_DeleteItem,LIST_OT_MoveItem,ParticleShapeKeys
            ,LSIT_OT_SelectItem
            ,UpdtParticleList
            ,CacheManipulationTest
            ,SetEqualDisplaySegments
            ,Rekey,UnifyLength
            ,HAIR_UL_ShapekeyList,CreateHairShapekey,DeleteHairShapekey
            ,DeleteBakes,CurrentCacheToBake,PlayPauseStyle
            ,ShapekeyApplyTest
            ,SelectLinked
            ,SaveHairShapePreset,LoadHairShapePreset,SaveHairChildrenPreset,LoadHairChildrenPreset
            ,SaveCheckpointHairShapePreset,LoadCheckpointHairShapePreset
            ,SaveCheckpointHairChildrenPreset,LoadCheckpointHairChildrenPreset
            ,Subdivide
            ,LockHairLayer,UnlockHairLayer
            ,SelectHairLayer
            ,UpdtParticleCurrent)


addon_keymaps = []
def add_hotkey():

    kc = bpy.context.window_manager.keyconfigs.addon
    # kc = bpy.context.window_manager.keyconfigs.user

    km = kc.keymaps.get('3D View')
    # km = kc.keymaps.get('Particle')
    if not km:
        print('not km')
        km = kc.keymaps.new(name='3D View', space_type='VIEW_3D')
        # km = kc.keymaps.new(name='Particle', space_type='VIEW_3D')
    # kmi = km.keymap_items.new('wm.call_menu_pie', 'D', 'PRESS', ctrl=True, shift = True)
    kmi = km.keymap_items.new('wm.call_menu_pie', 'D', 'PRESS', ctrl=True)
    # kmi = km.keymap_items.new('wm.call_menu_pie', 'D', 'PRESS')

    # kmi = km.keymap_items.new('wm.call_menu_pie', 'D', 'PRESS')
    kmi.properties.name = "HD_MT_HairMenu"
    kmi.active = True
    addon_keymaps.append((km, kmi))


def remove_hotkey():
    for km, kmi in addon_keymaps:
        km.keymap_items.remove(kmi)

    addon_keymaps.clear()

from bl_ui.space_toolsystem_common import ToolSelectPanelHelper

class PIE_MT_SubmenuSelectionMode(Menu):
    bl_label = 'Selection Mode'    
    def draw(self, context):
        layout = self.layout
        layout.label(text="Selection Mode")
        layout.separator()
        layout.operator("wm.tool_set_by_id", text = "Comb",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.comb")).name = 'builtin_brush.Comb'
        layout.operator("wm.tool_set_by_id", text = "Smooth",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.smooth")).name = 'builtin_brush.Smooth'
        layout.operator("wm.tool_set_by_id", text = "Add",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.add")).name = 'builtin_brush.Add'
        layout.operator("wm.tool_set_by_id", text = "Length",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.length")).name = 'builtin_brush.Length'
        layout.operator("wm.tool_set_by_id", text = "Puff",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.puff")).name = 'builtin_brush.Puff'
        layout.operator("wm.tool_set_by_id", text = "Cut",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.cut")).name = 'builtin_brush.Cut'
        # layout.operator("wm.tool_set_by_id", text = "Weight",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.weight")).name = 'builtin_brush.Eight'

class PIE_MT_SubmenuQuality(Menu):
    bl_label = 'More Options'    
    def draw(self, context):
        layout = self.layout
        # dyna_groom = context.scene.dyna_groom_prop
        layout.label(text="Hair Quality")
        layout.operator("hair.hq_hair",icon = "PROP_ON")
        layout.operator("hair.mq_hair",icon = "PROP_CON") 
        layout.operator("hair.lq_hair",icon = "PROP_OFF") 


class PIE_MT_Submenu(Menu):
    bl_label = 'More Options'    
    def draw(self, context):
        layout = self.layout
        dyna_groom = context.scene.dyna_groom_prop
        layout.label(text="Hair Options")
        layout.operator("hair.particle_edit_clear",icon = "GHOST_ENABLED") 
        layout.separator()
        layout.prop(dyna_groom,'int_hair_number')
        layout.prop(dyna_groom,'int_hair_size')

class PIE_MT_SubmenuLayer(Menu):
    bl_label = 'Layers'    
    def draw(self, context):
        layout = self.layout
        dyna_groom = context.scene.dyna_groom_prop
        layout.label(text="Layers")

        qty_particles = len(bpy.context.active_object.particle_systems)
        qty_ob_partic = len(bpy.context.active_object.hair_list)
        if qty_particles==qty_ob_partic and len(bpy.context.active_object.particle_systems)>0:
            pre_row = layout.row()
            # row = layout.row().box()
            row = pre_row.box()
            row = row.column(align=True)
            # for h in hair_sections:
            for ih,hair in enumerate(context.active_object.hair_list):
                i = 0
                hair_name=''
                pid = hair.particle_system_id
                for mod in bpy.context.object.modifiers:
                    if mod.type == 'PARTICLE_SYSTEM':
                        # if i == ih:
                        if i == pid:
                            # print(i)
                            hair_name = mod.name
                            # lock_hair_layer = hair.bool_lock_hair_layer
                            # print(hair_name)
                        i = i+1

                # idx =context.scene.hair_list_index
                # part_id = context.scene.hair_list[idx].particle_system_id
                # part_id = hair.particle_system_id
                
                col = layout.row(align=True)
                # col = row.box().column()
                if ih == context.active_object.hair_list_index:
                    # col.label(text=hair.name,icon='RESTRICT_SELECT_OFF')
                    col.operator('hair.select_hair_layer',text=hair.name,icon='RESTRICT_SELECT_OFF',emboss=False)
                    # select_hair.hair_id = part_id
                else:
                    select_hair = col.operator('hair.select_hair_layer',text=hair.name,icon='RESTRICT_SELECT_ON',emboss=True,translate=False)
                    select_hair.hair_id = ih
                    # col.label(text=hair.name,icon='RESTRICT_SELECT_ON')

                if bpy.context.object.particle_systems[pid].use_hair_dynamics == False:
                    dyna_on = col.operator('hair.hair_dynamics_on',text='',icon="RADIOBUT_OFF")
                    dyna_on.hair_id = pid
                else:
                    dyna_on = col.operator('hair.hair_dynamics_off',text='',icon="RADIOBUT_ON")
                    dyna_on.hair_id = pid


                if bpy.context.object.modifiers[hair_name].show_viewport == False:
                    show_vp_hair = col.operator('hair.show_viewport_hair',text='',icon="RESTRICT_VIEW_ON")
                    show_vp_hair.hair_id = pid
                    # show_vp_hair.hair_name = hair_name
                else:
                    hide_vp_hair = col.operator('hair.hide_viewport_hair',text='',icon="RESTRICT_VIEW_OFF")
                    hide_vp_hair.hair_id = pid
                    # hide_vp_hair.hair_name = hair_name
                    # hide_vp_hair.hair_id = ih
                if bpy.context.object.modifiers[hair_name].show_render == False:
                    show_render_hair = col.operator('hair.show_render_hair',text='',icon="RESTRICT_RENDER_ON")
                    show_render_hair.hair_id = pid
                    # show_render_hair.hair_id = ih
                else:
                    hide_render_hair = col.operator('hair.hide_render_hair',text='',icon="RESTRICT_RENDER_OFF")
                    hide_render_hair.hair_id = pid
                    # hide_render_hair.hair_id = ih
                # if lock_hair_layer:
                if context.active_object.hair_list[ih].bool_lock_hair_layer:
                    unlock_hair_layer = col.operator('hair.unlock_hair_layer',text='',icon="UNLOCKED")
                    unlock_hair_layer.hair_id = ih
                else:
                    lock_hair_layer = col.operator('hair.lock_hair_layer',text='',icon="LOCKED")
                    lock_hair_layer.hair_id = ih

        # layout.operator("hair.particle_edit_clear",icon = "GHOST_ENABLED") 
        # layout.separator()
        # layout.prop(dyna_groom,'int_hair_number')
        # layout.prop(dyna_groom,'int_hair_size')



class VIEW3D_MT_PIE_template(Menu):
    bl_idname = "HD_MT_HairMenu"
    bl_label = 'Hair Options'
    def draw(self, context):
                        
        layout = self.layout
        prefs = context.preferences
        inputs = prefs.inputs
        dyna_groom = context.scene.dyna_groom_prop
        id_to_update_name = dyna_groom.enum_hair_curr_section
        
        
        qtd_particles = len(bpy.context.active_object.particle_systems)

        pie = layout.menu_pie()
        # print('context: ', bpy.context.area.type)
        # print('qtd regions: ', len(bpy.context.area.regions))
        # for i,x in enumerate(bpy.context.area.regions):
        #     print('region type ',str(i+1),': ',x.type)
        ################################
#        Left
#        pie.operator("wm.call_menu_pie", text = "Some Other Pie0", icon = "RIGHTARROW_THIN").name="Pie_menu"
        if qtd_particles > 0:
            other = pie.column()
            other_menu = other.box().column()
            other_menu.operator("hair.add_dynamics", icon = "PLUS")
            other_menu.separator()
            other_menu.operator("hair.apply_dynamics", icon = "CHECKMARK") 
            if context.mode == 'PARTICLE':
                other_menu.separator()
                other_menu.prop(dyna_groom,'bool_particle_edit_show_children')
                other_menu.separator()
                other_menu.separator()
                # other_menu.operator("wm.tool_set_by_id", text = "Select Box",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("ops.generic.select_box")).name = 'builtin_select_box'
                other_menu.operator("wm.tool_set_by_id", text = "Comb",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.comb")).name = 'builtin_brush.Comb'
                other_menu.operator("wm.tool_set_by_id", text = "Smooth",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.smooth")).name = 'builtin_brush.Smooth'
                other_menu.operator("wm.tool_set_by_id", text = "Add",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.add")).name = 'builtin_brush.Add'
                other_menu.operator("wm.tool_set_by_id", text = "Length",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.length")).name = 'builtin_brush.Length'
                other_menu.operator("wm.tool_set_by_id", text = "Puff",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.puff")).name = 'builtin_brush.Puff'
                other_menu.operator("wm.tool_set_by_id", text = "Cut",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.cut")).name = 'builtin_brush.Cut'
                # other_menu.operator("wm.tool_set_by_id", text = "Weight",icon_value=ToolSelectPanelHelper._icon_value_from_icon_handle("brush.particle.weight")).name = 'builtin_brush.Eight'
            # other_menu.menu('PIE_MT_SubmenuQuality', icon='RIGHTARROW_THIN',  text='Hair Quality')
            # other_menu.menu('PIE_MT_Submenu', icon='RIGHTARROW_THIN',  text='Hair Opt')
            split_other = other_menu.split(factor=0.)
            split_other.menu('PIE_MT_SubmenuLayer', icon='RIGHTARROW_THIN')
            # other_menu.menu('PIE_MT_SubmenuLayer', icon='RIGHTARROW_THIN')
        else:
            pie.separator()
#        other_menu.menu('PIE_MT_Submenu', icon='RIGHTARROW_THIN',  text='Some Submenu...')
        ################################
#        Right
        # pie.separator()
        if qtd_particles > 0 :
            other = pie.column()
            other_menu = other.box().column()
            if context.mode == 'PARTICLE':
                other_menu.enabled = True
            else:
                other_menu.enabled = False
            other_menu.operator("hair.select_root", icon = "PIVOT_ACTIVE")
            other_menu.operator("hair.select_root_and_next",icon = "PIVOT_INDIVIDUAL")
            other_menu.operator("hair.select_tip",icon = "PARTICLE_TIP")
            other_menu.separator()
            other_menu.operator("hair.unselect", icon="PANEL_CLOSE")
            other_menu.operator("hair.invert_selection",icon="INDIRECT_ONLY_ON")
            other_menu.separator()
            other_menu.operator('hair.select_linked')
            other_menu.separator()
            other_menu.operator("hair.select_point_more",text="More", icon = "ADD")
            other_menu.operator("hair.select_point_less",text="Less", icon = "REMOVE")
            other_menu.separator()
            other_menu.prop(dyna_groom,'bool_particle_edit_preserve_length',toggle=True)
            other_menu.prop(dyna_groom,'bool_particle_edit_preserve_root',toggle=True)
            other_menu.separator()
            other_menu.operator('hair.subdivide')


    #        other_menu.menu('PIE_MT_Submenu', icon='RIGHTARROW_THIN',  text='Some Submenu...')
        else:
            pie.separator()
        ################################
#        Bottom
        if qtd_particles > 0:
            # pie.operator("hair.toggle_particle_context", text="Toggle Context", icon="ARROW_LEFTRIGHT")
            other = pie.column()
            other_menu = other.box().row()
            other_menu.operator('hair_list.select_item', text='',icon='TRIA_UP').direction = 'UP'
            other_menu.operator("hair.toggle_particle_context", text="Toggle Context", icon="ARROW_LEFTRIGHT")
            other_menu.operator('hair_list.select_item', text='',icon='TRIA_DOWN').direction = 'DOWN'
            other_menu_col = other.row()

            hair_index = context.active_object.hair_list_index
            qtd_layer = len(context.active_object.hair_list)
            item = context.active_object.hair_list[hair_index]
            text_layer = str(hair_index+1)+'/'+str(qtd_layer)
            if item.bool_lock_hair_layer:
                other_menu_col.prop(item,'bool_lock_hair_layer',icon='UNLOCKED',text=text_layer+' Lock: '+item.name,toggle=True,invert_checkbox=True)

                # unlock_hair = other_menu_col.operator('hair.unlock_hair_layer',icon='UNLOCKED',text='Lock Hair')
                # unlock_hair.hair_id = context.active_object.hair_list_index
            else:
                other_menu_col.prop(item,'bool_lock_hair_layer',icon='LOCKED',text=text_layer+' Unlock: '+item.name,toggle=True,invert_checkbox=True)
                # lock_hair = other_menu_col.operator('hair.lock_hair_layer',icon='LOCKED',text='Unlock Hair')
                # lock_hair.hair_id = context.active_object.hair_list_index
        else:
            pie.separator()
        # other_menu.menu('PIE_MT_SubmenuLayer', icon='RIGHTARROW_THIN',width=300)
        
        # pie.separator()
        ################################
#        Top   
#        pie.operator("mesh.primitive_cube_add", text = "Some Operator2", icon = "BLENDER")
        if qtd_particles > 0:
            other = pie.column()
            other_menu = other.box().column()
            # other_menu.operator("hair.mode_path", text = "Path",icon = "PARTICLE_PATH")
            # other_menu.operator("hair.mode_point", text = "Point",icon = "PARTICLE_POINT") 
            # other_menu.operator("hair.mode_tip", text = "Tip",icon = "PARTICLE_TIP") 
            other_menu = other_menu.row(align=True)
            if context.mode == 'PARTICLE':
                other_menu.enabled = True
            else:
                other_menu.enabled = False
            other_menu.prop(dyna_groom,'bool_editmode_path',text = "Path",icon = "PARTICLE_PATH",toggle=True)
            other_menu.prop(dyna_groom,'bool_editmode_point', text = "Point",icon = "PARTICLE_POINT" ,toggle=True)
            other_menu.prop(dyna_groom,'bool_editmode_tip', text = "Tip",icon = "PARTICLE_TIP",toggle=True)
            if addon_utils.check('3D Hair Brush')[1]:
                other_menu_col = other.box().column(align=True)
                if context.mode == 'PARTICLE':
                    other_menu_col.enabled = True
                else:
                    other_menu_col.enabled = False
                other_menu_col.label(text='VFX Grace Brush')
                other_menu_col2 = other_menu_col.row(align=True)
                other_menu_col2.prop(dyna_groom,'vfxgrace_bool_3d_brush',text='3D',toggle=True)
                other_menu_col3 = other_menu_col2.row(align=True)
                if bpy.context.scene.hair_brush_3d.use_3d_brush:
                    other_menu_col3.enabled = True
                else:
                    other_menu_col3.enabled = False
                other_menu_col3.prop(dyna_groom,'vfxgrace_bool_auto_switch',text='Auto',toggle=True)
                other_menu_col3.prop(dyna_groom,'vfxgrace_bool_brush_scale',text='Scale',toggle=True)


    #        other_menu.menu('PIE_MT_Submenu', icon='RIGHTARROW_THIN',  text='Some Submenu...')
        else:
            pie.separator()
        ################################
#        Top_left
#        pie.operator("mesh.primitive_cube_add", text = "Some Operator3", icon = "BLENDER")
        # pie.separator() #comment if this part will be anabled
        # if qtd_particles > 0:
        #     other = pie.column()
        #     other_menu = other.box().column()
        #     # other_menu.menu('PIE_MT_SubmenuSelectionMode', icon='RIGHTARROW_THIN',  text='Toolbar')
        #     other_menu.menu('PIE_MT_Submenu', icon='RIGHTARROW_THIN',  text='Hair Opt')
        # else:
        #     pie.separator()
        pie.separator()
        ################################
#        Top_right
#        pie.operator("mesh.primitive_cube_add", text = "Some Operator4", icon = "BLENDER")
        pie.separator() #comment if this part will be anabled
        # pie.operator('hair.select_linked') esse aqui nao ficou bom por que ficou sobrepondo um pouco o TIP
        
        ################################
#        Bottom_left
        # if qtd_particles > 0:
        #     pie.operator("hair.toggle_particle_context", text="Toggle Context", icon="ARROW_LEFTRIGHT")
        #     # other = pie.column()
        #     # other_menu = other.box().column()
        #     # other_menu.operator("wm.tool_set_by_id", text = "Brush",icon_value=975).name = 'builtin_brush.Comb'

        # else:
        #     pie.separator()
        pie.separator()
        ################################
#        Bottom_right
#        pie.operator("mesh.primitive_cube_add", text = "Some Operator6", icon = "BLENDER")
        pie.separator()
        # if qtd_particles > 0:
        #     other = pie.column()
        #     other_menu = other.box().column()
        #     if context.mode == 'PARTICLE':
        #         other_menu.enabled = True
        #     else:
        #         other_menu.enabled = False
        #     other_menu.operator("hair.select_point_more",text="More", icon = "ADD")
        #     other_menu.operator("hair.select_point_less",text="Less", icon = "REMOVE")
        #     # other_menu.operator("hair.hair1")
        #     # other_menu.operator("hair.hair2")
        # else:
        #     pie.separator()

def updt_hair_list_index(self,context):

    if len(context.active_object.hair_list) > 0 :
        dyna_groom = context.scene.dyna_groom_prop
        idx = self.hair_list_index
        if bpy.context.active_object.particle_systems.active_index != context.active_object.hair_list[idx].particle_system_id:
            bpy.context.active_object.particle_systems.active_index = context.active_object.hair_list[idx].particle_system_id 

            item = context.active_object.hair_list[context.active_object.hair_list_index]

            dyna_groom.str_save_preset_name = item.name
            dyna_groom.str_save_hair_shape_preset_name = item.name
            dyna_groom.str_save_hair_children_preset_name = item.name
        
        hair.update_hair_values_on_panel(context)

def updt_hair_shapekey_index(self,context):

    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    hair_settings = context.object.particle_systems[idx_particle].settings
    hair_list_shapekey = hair_settings.particle_shape
    # hair_list_shapekey_index = hair_settings.particle_shape_index
    hair_list_shapekey_index = self.particle_shape_index

    #########################
    ### save current pose
    # idx = bpy.context.active_object.hair_list_index
    # idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
        
    deps_graph = bpy.context.evaluated_depsgraph_get()
    evaluated_object = bpy.context.object.evaluated_get(deps_graph)
    particle_system = evaluated_object.particle_systems.active
    
    hairs = []

    for p in particle_system.particles:
        hair = []
        for v in p.hair_keys:
            hair.append([v.co[0], v.co[1], v.co[2]])
        hairs.append(hair)
    
    save_hairs = json.dumps(hairs)
    hair_settings.particle_last_shape = save_hairs
    ### save current pose
    #########################

    ###############################
    #### load current shapekey
    if len(hair_list_shapekey) > 0 :
        bpy.ops.object.mode_set(mode='OBJECT')

        load_hairs = json.loads(bpy.context.object.particle_systems[idx_particle].settings.particle_shape[hair_list_shapekey_index].partic_data)
        # print(load_hairs)

        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        # assume context object has a particle system (warning, no check), use active
        particle_system = evaluated_object.particle_systems.active
        



        for p,hair in zip(particle_system.particles,load_hairs):
            # print('p: ',p)
            # print('hair: ',hair)
            for v,h in zip(p.hair_keys,hair):
                #print(v.co, h)
                v.co[0] = h[0]
                v.co[1] = h[1]
                v.co[2] = h[2]
                #print(v.co, h)

        # bpy.ops.particle.brush_edit(stroke=[{"name":"", "location":(0, 0, 0), "mouse":(126, 160), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}])
        # print('context area type: ',bpy.context.area.type)

        
        # bpy.context.object.particle_systems.update()
        # bpy.data.particles.update()
        # bpy.context.view_layer.depsgraph.update(evaluated_object.particle_systems.active)
        bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
        bpy.ops.object.mode_set(mode='OBJECT')
        #### load current shapekey
        ###############################
 
def updt_hair_shapekey_index_fullstack(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_enable_shapekey:
        # dyna_groom = bpy.context.scene.dyna_groom_prop
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index



        load_base = json.loads(hair_list_shapekey[0].partic_data)
        for i_ps,ps in enumerate(hair_list_shapekey):
            # print (i_ps,' - ',ps.partic_name)
            # if i_ps ==1: #guada a informacao da base shapekey
            #     load_last = load_base
            if i_ps >= 1: #no i_ps =1 o last é  load_base, por isso o post_influence esta vazio
                if i_ps == 1:
                    load_last = load_base
                else:
                    load_last = json.loads(hair_settings.particle_shape[i_ps-1].partic_data_post_influence)
                    # load_last = json.loads(hair_settings.particle_last_shape)
                #carrega dado atual
                load_hair = json.loads(ps.partic_data)
                influence = ps.partic_shapekey_influence

                bpy.ops.object.mode_set(mode='OBJECT')
                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active

                precision = 4
                precision_string = "{:."+str(precision)+"f}" #ajuste necessario pois, apesar de nao mover alguns pontos, propositalmente, eles acabam sendo movimentados, e isso bagunca o funcionamento

                # for p,base,l_last,hair in zip(particle_system.particles,load_base,load_last,load_hair): #fios de cabelo
                for i_h,hair_strand in enumerate(zip(particle_system.particles,load_base,load_last,load_hair)): #fios de cabelo
                    p = hair_strand[0]
                    base = hair_strand[1]
                    l_last = hair_strand[2]
                    hair = hair_strand[3]
                    # for v,b,ll,h in zip(p.hair_keys,base,l_last,hair): #ponto dos fios de cabelo "keys"
                    for i_h_key,hair_keys in enumerate(zip(p.hair_keys,base,l_last,hair)): #ponto dos fios de cabelo "keys"
                        v = hair_keys[0]
                        b = hair_keys[1]
                        ll = hair_keys[2]
                        h = hair_keys[3]
                        # print(i_h,'-',i_h_key)
                        # if b[0] != h[0]:
                        # if "{:.4f}".format(b[0]) != "{:.4f}".format(h[0]) :
                        if precision_string.format(b[0]) != precision_string.format(h[0]) :
                            v.co[0] = ll[0]+((h[0] - ll[0]) * influence)
                        else:
                            v.co[0] = ll[0]
                        # if b[1] != h[1]:
                        # if "{:.4f}".format(b[1]) != "{:.4f}".format(h[1]) :
                        if precision_string.format(b[1]) != precision_string.format(h[1]) :
                            v.co[1] = ll[1]+((h[1] - ll[1]) * influence)
                        else:
                            v.co[1] = ll[1]
                        # if b[2] != h[2]:
                        # if "{:.4f}".format(b[2]) != "{:.4f}".format(h[2]) :
                        if precision_string.format(b[2]) != precision_string.format(h[2]) :
                                v.co[2] = ll[2]+((h[2] - ll[2]) * influence)
                        else:
                            v.co[2] = ll[2]

                #ao terminar de rodar todos os fios de cabelo
                bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
                bpy.ops.object.mode_set(mode='OBJECT') #fixar os valores

                    # Apos processar, guardar a nva forma na propriedade particle_last_shape


                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active
                
                hairs = []

                for p in particle_system.particles:
                    hair = []
                    for v in p.hair_keys:
                        hair.append([v.co[0], v.co[1], v.co[2]])
                    hairs.append(hair)

                # hairs____ = hairs
                
                save_hairs = json.dumps(hairs)
                # hair_settings.particle_last_shape = save_hairs
                ps.partic_data_post_influence = save_hairs
    else:
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        # hair_list_shapekey_index = hair_settings.particle_shape_index
        hair_list_shapekey_index = self.particle_shape_index

        #########################
        ### save current pose
        # idx = bpy.context.active_object.hair_list_index
        # idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
            
        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        particle_system = evaluated_object.particle_systems.active
        
        hairs = []

        for p in particle_system.particles:
            hair = []
            for v in p.hair_keys:
                hair.append([v.co[0], v.co[1], v.co[2]])
            hairs.append(hair)
        
        save_hairs = json.dumps(hairs)
        hair_settings.particle_last_shape = save_hairs
        ### save current pose
        #########################

        ###############################
        #### load current shapekey
        if len(hair_list_shapekey) > 0 :
            bpy.ops.object.mode_set(mode='OBJECT')

            load_hairs = json.loads(bpy.context.object.particle_systems[idx_particle].settings.particle_shape[hair_list_shapekey_index].partic_data)
            # print(load_hairs)

            deps_graph = bpy.context.evaluated_depsgraph_get()
            evaluated_object = bpy.context.object.evaluated_get(deps_graph)
            # assume context object has a particle system (warning, no check), use active
            particle_system = evaluated_object.particle_systems.active
            



            for p,hair in zip(particle_system.particles,load_hairs):
                # print('p: ',p)
                # print('hair: ',hair)
                for v,h in zip(p.hair_keys,hair):
                    #print(v.co, h)
                    v.co[0] = h[0]
                    v.co[1] = h[1]
                    v.co[2] = h[2]
                    #print(v.co, h)

            # bpy.ops.particle.brush_edit(stroke=[{"name":"", "location":(0, 0, 0), "mouse":(126, 160), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}])
            # print('context area type: ',bpy.context.area.type)

            
            # bpy.context.object.particle_systems.update()
            # bpy.data.particles.update()
            # bpy.context.view_layer.depsgraph.update(evaluated_object.particle_systems.active)
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
            bpy.ops.object.mode_set(mode='OBJECT')

def register():

    from bpy.utils import register_class
    for cls in classes:
        register_class(cls)
    
    bpy.utils.register_class(VIEW3D_MT_PIE_template)
    bpy.utils.register_class(PIE_MT_SubmenuQuality)
    bpy.utils.register_class(PIE_MT_SubmenuSelectionMode)
    bpy.utils.register_class(PIE_MT_Submenu)
    bpy.utils.register_class(PIE_MT_SubmenuLayer)
    add_hotkey()
    bpy.types.Scene.dyna_groom_prop = PointerProperty(type=DynaGroomSettings)
    
    ##ui list
    # bpy.types.Scene.hair_list = CollectionProperty(type = ListItem)
    # bpy.types.Scene.hair_list_index = IntProperty(name = "Index for hair_list",default = 0)

    bpy.types.Object.hair_list = CollectionProperty(type = ListItem)
    bpy.types.Object.hair_list_index = IntProperty(name = "Index for hair_list",default = 0,update=updt_hair_list_index)
    bpy.types.ParticleSettings.particle_shape = CollectionProperty(type = ParticleShapeKeys)
    # bpy.types.ParticleSettings.particle_shape_index = IntProperty(name = "Index for Particle Shape",default = 0,update=updt_hair_shapekey_index)
    bpy.types.ParticleSettings.particle_shape_index = IntProperty(name = "Index for Particle Shape",default = 0,update=updt_hair_shapekey_index_fullstack)
    bpy.types.ParticleSettings.particle_last_shape = StringProperty(name = "Data before loading current shapekey")#,update=updt_)
    
    


    ### Booleans for Menu
    bpy.types.Scene.ceb_dyna_groom_colapse0 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.ceb_dyna_groom_colapse1 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.ceb_dyna_groom_colapse2 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.ceb_dyna_groom_colapse3 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.ceb_dyna_groom_colapse_vg = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.ceb_dyna_groom_colapse_shapekey = bpy.props.BoolProperty(default=False)

    pre_frame_handlers = bpy.app.handlers.frame_change_pre
    [pre_frame_handlers.remove(f) for f in pre_frame_handlers if f.__name__ == "stop_playback" or f.__name__ =="handler_hair_shapekey_index_fullstack"]
    pre_frame_handlers.append(stop_playback)
    pre_frame_handlers.append(handler_hair_shapekey_index_fullstack)
    

    pre_handlers = bpy.app.handlers.depsgraph_update_pre
    [pre_handlers.remove(h) for h in pre_handlers if h.__name__ == "hair_list_handler"]
    pre_handlers.append(hair_list_handler)
    
   

def unregister():
    from bpy.utils import unregister_class
    for cls in reversed(classes):
        unregister_class(cls) 
    bpy.utils.unregister_class(VIEW3D_MT_PIE_template)
    bpy.utils.unregister_class(PIE_MT_SubmenuQuality)
    bpy.utils.unregister_class(PIE_MT_SubmenuSelectionMode)
    bpy.utils.unregister_class(PIE_MT_Submenu)
    bpy.utils.unregister_class(PIE_MT_SubmenuLayer)
    remove_hotkey()
    del bpy.types.Scene.dyna_groom_prop
    del bpy.types.Scene.ceb_dyna_groom_colapse0
    del bpy.types.Scene.ceb_dyna_groom_colapse1
    del bpy.types.Scene.ceb_dyna_groom_colapse2
    del bpy.types.Scene.ceb_dyna_groom_colapse3
    del bpy.types.Scene.ceb_dyna_groom_colapse_vg
    del bpy.types.Scene.ceb_dyna_groom_colapse_shapekey

    del bpy.types.Object.hair_list
    del bpy.types.Object.hair_list_index
    del bpy.types.ParticleSettings.particle_shape
    del bpy.types.ParticleSettings.particle_shape_index


    pre_frame_handlers = bpy.app.handlers.depsgraph_update_pre
    # [pre_frame_handlers.remove() for h in pre_frame_handlers if h.__name__ == "stop_playback"]
    # [pre_frame_handlers.remove(h) for h in pre_frame_handlers if h.__name__ == "handler_hair_shapekey_index_fullstack"]
    # [pre_frame_handlers.remove(i) for i in pre_frame_handlers if i.__name__ == "stop_playback"]
    # [pre_frame_handlers.remove(j) for j in pre_frame_handlers if j.__name__ == "handler_hair_shapekey_index_fullstack"]
    [pre_frame_handlers.remove(f) for f in pre_frame_handlers if f.__name__ == "stop_playback" or f.__name__ =="handler_hair_shapekey_index_fullstack"]

    pre_handlers = bpy.app.handlers.depsgraph_update_pre
    [pre_handlers.remove(h) for h in pre_handlers if h.__name__ == "hair_list_handler"]
    # [pre_handlers.remove(h) for h in pre_handlers if h.__name__ == "handler_hair_shapekey_index_fullstack"]

    

 
 
if __name__ == "__main__":
    register()